; assemble with AS8080
;
;this file can be used as an external DD for Z80SIM 4mb disk images.
; when this file is present in the same directory as the image file,
;  it will be used as an external DD 
;    as though it is in sector 5 of the target disk image
;
; this file should be assembled and placed into a file 
;  with the same name as the disk that it is to be used with...
;  
; if a 4mb disk image for the Z80 SIM is named 
;    disk.dsk
;then name this file
;    disk.dsk.dd
;
;-------------------------

Set8	macro	?Register,?Value
	db	1,?Register,?Value
	endm
Set16	macro	?Register,?Value
	db	2,?Register
	dw	?Value
	endm

;-------------------------

Magic	equ	0
DPB	equ	0x08
NDI	equ	0x20
DD	equ	0x80

	org	Magic
	db	"NDI-Z80E"

	org	DPB
UMHD4D
	DW	128	;sectors per track
	DB	4	;block shift factor
	DB	15	;block mask
	DB	0	;extent mask
	DW	2039	;disk size-1
	DW	1023	;directory max
	DB	255	;alloc 0
	DB	255	;alloc 1
	DW	256	;check size
	DW	0	;track offset
	DB	0,0	;physical sector size and shift

eo$dpb
	rept	NDI-eo$dpb
	db	0
	endm

	org	NDI

UMHD4P:
	set8	080h,0		;order
	set8	081h,0		;formatType
	set8 	082h,0		;DONT use prepost

	set16	09ah,0		;IDM flag	0

	set16	0a0h,255	;Cylinders
	set8	0a1h,1		;Heads

	set8	0a3h,0		;density	(data) 	Don't care
	set16	0a4h,128	;SPT		(data) 
	set8	0a5h,0		;Sector Size	(data) 	128
	set8	0a6h,1		;clock		(data) 	HD

	db	0ffh
eo$ndi
	rept	DD-eo$ndi
	db	0
	endm

eodd	equ	$

	end
;-------------------------